<?php

global $reviewsite_app,$id_tinymce,$image_upload;
$image_upload	= 0;

$id_tinymce	= array();

class ReviewSiteApp 
{
	var $table;
	var $structure;
	var $setting;

	/* initialization */
	function init()
	{

		//initalization variable
		
		//calling any functions for the first time
		
		add_action('admin_menu',array(&$this,"createMenu"));
		add_action('admin_head',array(&$this,"adminCSSJS"));
		add_action('admin_print_scripts', array(&$this,'adminScripts'));
		add_action('admin_print_styles', array(&$this,'adminStyles'));
		
	}

	// check table if exists
	function checkTable($table)
	{	
		global $wpdb;
	
		$query	= "SHOW TABLES LIKE '".$wpdb->prefix.$table."'";
		
		$result	= $wpdb->get_results($query,ARRAY_A);
		
		if(is_array($result) && isset($result[0])) { return "true"; } else { return "false"; }
	}
	
	// create table if the table is not exists
	function createTable($table,$structure)
	{
		global $wpdb;
		
		$query	= "CREATE TABLE IF NOT EXISTS `".$wpdb->prefix.$table."` (".
					$structure.
				  ") ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;";
		
		$wpdb->query($query);
	}
	
	// delete table
	function deleteTable($table)
	{
		global $wpdb;
		$sql	= "DROP TABLE `".$wpdb->prefix.$table."`";
		$wpdb->query($sql);
	}
	
	// create menu
	function createMenu()
	{
		$icon	= THEMELINK.'/admin/images/broadcast.png';
		//add_submenu_page( 'reviewSite', 'ReviewSite &bull; Setting', 'Setting', 'manage_options', 'admin.php?page=reviewSite-setting', array("ReviewSiteSetting","view"));		
		add_menu_page( "ReviewSite Setting", "ReviewSite", "manage_categories", "reviewSite", array("ReviewSiteSetting","view"), $icon);
	}
	
	function beforeInput($label)
	{
		?>
		<div class="input-row">
			<label><?php echo $label; ?></label>
			<div class="input-field">
        <?php
	}
	
	function afterInput()
	{
		?>
			</div>                
			<div class="wrapper"></div>
		</div>
        <?php
	}

	//generateCatOptions
	function generateCategoryOptions($label,$part,$section)
	{
		global $th_pre;
		$opt_name	= $th_pre.$part."_".$section;
		$id			= str_replace("_","-",$opt_name);
		$value		= stripslashes(get_option($opt_name));
		$name		= "data[".$opt_name."]";
		
		$cat_id		= $value;
		
		$this->beforeInput($label);
	
		?><select name="<?php echo $name; ?>" id="<?php echo $id; ?>"><?php
	
		$args	= array(
			'hide_empty'	=> 0,
		);
	
  		$cats = get_categories($args);
  	
		foreach ($cats as $cat) :
  			$option = '<option value="'.$cat->term_id.'" ';
			
			if(is_array($cat_id) && in_array($cat->term_id,$cat_id)) { $option .= "selected='selected'"; }
			elseif($cat_id == $cat->term_id) { $option .= "selected='selected'"; }
		
			$option .= ">&nbsp;&nbsp;";
		
			$option .= $cat->name;
			$option .= '</option>';
			echo $option;
		endforeach;
		
		?></select><?php
		
		$this->afterInput();
	}
	
	//generatePageOptions
	function generatePageOptions($label,$part,$section,$multiple = false)
	{
		global $th_pre;
		$this->beforeInput($label);
		
		$name		= $th_pre.$part."_".$section;
		$value		= stripslashes(get_option($name));
		$opt_name	= "data[".$name."]";
		
		if($multiple) :
			$opt_name .= "[]";
			$value		= explode(',',$value);
			
		endif;
	
		$args	= array(
			'post_type' => 'page',
			'selected'	=> $value, 
			'name' 		=> $opt_name,
			'id'		=> str_replace("]","",str_replace("[","_",$name)),
			'sort_column'	=> 'menu_order, post_title',
			'echo'		=> 0,
		);
		
		
		$dropdown	= wp_dropdown_pages($args);
		
		if($multiple) :
			$dropdown	= str_replace("<select","<select multiple='multiple' style='height:300px;width:100%;' ",$dropdown);
		endif;
		
		echo $dropdown;
		
		$this->afterInput();
	}
	
	// generateCustomPostOptions
	function generateCustomPostOptions($metakey)
	{
		global $wpdb;
		
		$query	= "SELECT distinct(meta_value) AS meta_value ".
				  "FROM ".$wpdb->prefix."postmeta ".
				  "WHERE meta_key = '".$metakey."' ";
				  
		$results	= $wpdb->get_results($query, ARRAY_A);
		
		foreach($results as $result) :
			?><option value="<?php echo $result['meta_value']; ?>"><?php echo $result['meta_value']; ?></option><?php
		endforeach;
		
	}

	// generatePostOptions	
	function generatePostOptions($category_id,$column = "post_title")
	{
		$args	= array(
			'category'	=> $category_id
		);
	
  		$pages = get_posts($args);
  	
		foreach ($pages as $pagg) :
  			$option = '<option value="'.$pagg->$column.'">';
			$option .= $pagg->$column;
			$option .= '</option>';
			echo $option;
		endforeach;
	}
	
	// generateSubCategoryOptions
	function generateSubCategoryOptions($category_id)
	{
		$args	= array(
			'hide_empty'	=> 0,
			'child_of'		=> $category_id
		);
	
  		$cats = get_categories($args);
	
		foreach ($cats as $cat) :
  			$option = '<option value="'.$cat->term_id.'">';
			$option .= $cat->name;
			$option .= '</option>';
			echo $option;
		endforeach;
	}
	
	// generateOptions
	function generateOptions($label,$part,$section,$options)
	{
		global $th_pre;
		$opt_name	= $th_pre.$part."_".$section;
		$id			= str_replace("_","-",$opt_name);
		$value		= stripslashes(get_option($opt_name));
		$name		= "data[".$opt_name."]";
	
		$this->beforeInput($label);
		
		?>
		<select name="<?php echo $name; ?>" id="<?php echo $id; ?>">
		<?php
		
		foreach($options as $key => $label) :
			$selected	= "";
			if($label == $value) { $selected = "selected='selected'"; }
			
			?><option value="<?php echo $key; ?>" <?php echo $selected; ?>><?php echo $label; ?></option><?php
		
		endforeach;
		
		?></select><?php
		
		$this->afterInput();
	}
	
	// generateInputText
	function generateInputText($label,$part,$section)
	{
		global $th_pre;
		$opt_name	= $th_pre.$part."_".$section;
		$id			= str_replace("_","-",$opt_name);
		$value		= stripslashes(get_option($opt_name));
		$name		= "data[".$opt_name."]";
	
		$this->beforeInput($label);
		
		?>
        <input type="text" name="<?php echo $name; ?>" id="<?php echo $id; ?>" value="<?php echo $value; ?>" />
		<?php
		
		$this->afterInput();
	}
	
	// generateInputTextarea
	function generateInputTextarea($label,$part,$section,$use_editor = false)
	{
		global $th_pre,$id_tinymce;
		$opt_name	= $th_pre.$part."_".$section;
		$id			= str_replace("_","-",$opt_name);
		$value		= stripslashes(get_option($opt_name));
		$name		= "data[".$opt_name."]";
	
		$this->beforeInput($label);
		
		?>
        <textarea name="<?php echo $name; ?>" id="<?php echo $id; ?>"><?php echo $value; ?></textarea>
		<?php
		
		$this->afterInput();
		
		if($use_editor) :
			array_push($id_tinymce,$id);
		endif;
	}
	
	// generateImageUpload
	function generateImageUpload($label,$part,$section,$preview = false)
	{
		global $th_pre,$image_upload;
		$image_upload	= $image_upload + 1;
		$opt_name		= $th_pre.$part."_".$section;
		$id				= str_replace("_","-",$opt_name);
		$value			= stripslashes(get_option($opt_name));
		$name			= "data[".$opt_name."]";
	
		$this->beforeInput($label);
		
		?>
        <input id="upload_image_<?php echo $image_upload; ?>"  type="text" name="<?php echo $name; ?>" id="<?php echo $id; ?>" 
        	   value="<?php echo $value; ?>" size="70" />
		<input id="upload_image_button_<?php echo $image_upload; ?>" type="button" value="Upload Image" />
		<?php
		
		if($preview) :
		?><div id="preview-<?php echo $image_upload; ?>" class="preview-image"><img src="<?php echo $value; ?>" /></div><?php
		endif;
		
		$this->afterInput();
		
	}
	
	// generateTinyMCE
	function generateTinyMCE()
	{
		global $id_tinymce;
		
		?>
        <script type="text/javascript" language="javascript1.2">
		tinyMCE.init({
			mode	: "exact",
			elements: "<?php echo implode(",",$id_tinymce); ?>",
			theme : "advanced",
			plugins	: "advimage",
        	theme_advanced_buttons1 : "bold,italic,underline,strikethrough" + ",|,justifyleft,justifycenter,justifyright,justifyfull" + ",|,styleselect,formatselect,fontselect,fontsizeselect",
	        relative_urls : false,
    	    remove_script_host : false,
	        theme_advanced_toolbar_location : "top",
    	    theme_advanced_toolbar_align 	: "left",
        	theme_advanced_statusbar_location 	: "bottom",
	        theme_advanced_resizing 			: true
		});
		</script>
        <?php
	}
	
	// set variable
	function set($name,$value)
	{
		$this->$name	= $value;
	}
	
	// add CSS and JS if necessary
	function adminCSSJS() 
	{
		?>

		<style type="text/css">
			#toplevel_page_reviewSite .wp-submenu .wp-first-item {
				display	: none;
			}
		
		
		
			#reviewSite-body .metabox-holder { 
			width: 350px; float: left;
			margin: 0; padding: 0 10px 0 0;
			}
			
			#reviewSite-body .metabox-holder .postbox .inside {
			padding: 0 10px;
			}
			
			#reviewSite-body .metabox-holder h3 {
			}
			
			#reviewSite-body .metabox-holder h4 {
				clear	: both;
				color	: #21759B;
				padding	: 7px 9px;
				margin-top	: 20px;
				border-bottom	: 1px dotted #ccc;
			}
			
			#reviewSite-body .metabox-holder .input-row {
				padding	: 5px;
			}
			
			#reviewSite-body .metabox-holder label {
				float	: left;
				width	: 200px;
				padding	: 5px 0;
			}
			
			#reviewSite-body .metabox-holder input.text,
			#reviewSite-body .metabox-holder select {

			}
			
			#reviewSite-body .metabox-holder .input-radio,
			#reviewSite-body .metabox-holder .input-field {
				float	: left;
			}
			
			#reviewSite-body .metabox-holder select.multiple {
				margin	: 0;
				height	: 90px;
			}
			
			#wpbody #reviewSite-body .metabox-holder .input-field select {
				padding	: 3px 0;
			}
			
			#wpbody #reviewSite-body .metabox-holder .input-field select,
			#wpbody #reviewSite-body .metabox-holder .input-field input[type=text] {
				width	: 400px;
			}
			
			#wpbody #reviewSite-body .metabox-holder .input-field input.upload-button {
				width	: 100px;
			}
			
			#wpbody #reviewSite-body .metabox-holder textarea {
				width	: 650px;
				height	: 200px;
			}
			
			
			#reviewSite-body .metabox-holder p.info {
				padding	: 0;
				margin	: 0;
				font-style	: italic;
				color	: #aaa;
			}
			
			#reviewSite-body .metabox-holder .input-button {
				text-align	: center;
				padding		: 5px;
				margin-bottom	: 10px;
			}
			
			#reviewSite-body .metabox-holder .input-button input {
				padding	: 5px 30px;
				border	: 1px solid #333;
				background	: #333;
				color		: white;
				border-radius	: 5px;
				-webkit-border-radius	: 5px;
				-moz-border-radius		: 5px;
			}
			
			#reviewSite-body .metabox-holder em {
				font-size	: 10px;
			}
			
			#reviewSite-body .metabox-holder .wrapper {
				clear	: both;
			}
			
			.message ul {
				margin-top	: 5px;
				margin-left	: 20px;
				list-style	: disc;
			}
			
			.error {
				color	: maroon;
			}
			
			.reviewSite-metabox label {
				float	: left;
				width	: 100px;
				padding	: 6px;
			}
			
			#wpbody .widefat th { text-align:center; }
	    </style>
        
		<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery(".fade").fadeIn(1000).fadeTo(1000, 1).fadeOut(1000);
			jQuery(".toplevel_page_reviewSite").attr("href","admin.php?page=reviewSite-setting");
		});
		</script>
		<?php
	}
	
	function adminScripts()
	{

	}
	
	function adminStyles()
	{
		
	}
}

$reviewsite_app	= new ReviewSiteApp;
$reviewsite_app->init();

?>